<?php
namespace App\Http\Middleware;

use Closure;

use Illuminate\Http\Request;

use Symfony\Component\HttpFoundation\Response;

class CommonMiddleware

{

    /**

     * Handle an incoming request.

     *

     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next

     */

    public function handle(Request $request, Closure $next): Response

    {

        $user = $request->user();

        if($user->role != 'admin' && $user->role != 'manager'){

            abort(403);

        }

        return $next($request);

    }

}