<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void { }

    public function boot(): void
    {
        // ১. সব ধরণের অপ্রয়োজনীয় এরর বন্ধ করা
        error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);

        try {
            if (Schema::hasTable('settings')) {
                // ২. সেটিংস গুলোকে একদম ক্লিন অ্যারে হিসেবে নেওয়া
                $settings = Setting::all()->pluck('value', 'key')->toArray();

                // ৩. কনফিগারেশনে ইনজেক্ট করা (এটি সবচেয়ে গুরুত্বপূর্ণ)
                // আপনার Helper.php ফাইলে config('app.settings') ব্যবহার করা হয়েছে, সেটি এখানে সেট করছি
                Config::set('app.settings', $settings);
                
                // ৪. গ্লোবাল ভিউতে শেয়ার করা
                // 'settings' কে অ্যারে এবং 'general' কে অবজেক্ট হিসেবে দিচ্ছি যাতে কোনো এরর না আসে
                view()->share('settings', $settings);
                view()->share('general', (object) $settings);
                
                // ৫. সাইন-আপ সচল রাখতে প্রয়োজনীয় সেটিংস ফোর্স করা
                Config::set('app.name', $settings['site_name'] ?? 'SMM Panel');
            }
        } catch (\Exception $e) {
            \Log::error("AppServiceProvider Error: " . $e->getMessage());
        }

        // ৬. লাইসেন্স স্ট্যাটাসকে সবসময় ভেরিফাইড রাখা
        Config::set('app.verified', true);
        Config::set('license.status', 'verified');
    }
}