@extends('layouts.backend.app')

@section('content')
    <h1 class="h3 mb-3">All Class Links</h1>

    <div class="card">
        <div class="card-header">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">Add New</button>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Course</th>
                            <th>Link</th>
                            <th>Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($links as $i)
                            <tr>
                                <td>
                                    ID: {{ $i->user?->id }} <br>
                                    Name: {{ $i->user?->name }} <br>
                                    Role: {{ $i->user?->role }}
                                </td>
                                <td>
                                    {{ $i->course?->name }}
                                </td>
                                <td>
                                    <a target="_blank" href="{{ $i->link }}" class="btn btn-sm btn-primary">Click</a>
                                </td>
                                <td>
                                    {{ $i->time->format('d M Y, h:i a') }}
                                </td>
                                <td>
                                    <button class="btn btn-danger" onclick="deleteData({{ $i->id }})">
                                        <i class="align-middle" data-feather="trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $links->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('classLinks') }}" method="post">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="addModalLabel">Add new class link</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="" class="form-label">Course</label>
                            <select name="course" class="form-select" required>
                                @foreach ($courses as $c)
                                    <option value="{{ $c->id }}">{{ $c->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="" class="form-label">Link</label>
                            <input type="text" name="link" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="" class="form-label">Time</label>
                            <input type="datetime-local" name="time" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <form action="" method="post" id="delete-form">@csrf @method('DELETE')</form>
@endsection

@push('js')
    <script>
        const deleteForm = document.getElementById('delete-form');

        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored");
            if (ask) {
                deleteForm.action = window.location.origin + window.location.pathname + '/' + id;
                deleteForm.submit();
            }
        }
    </script>
@endpush