@extends('layouts.backend.app')

@section('content')
    <h1 class="h3 mb-3">Add New Course</h1>

    <div class="card">
        <form action="{{ route('admin.courses.store') }}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name<span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" required>
                        @error('name')
                            <p class="text-danger">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Description</label>
                        <textarea name="description" rows="3" class="form-control"></textarea>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Image<span class="text-danger">*</span></label>
                        <input type="file" name="image" class="form-control" required>
                        @error('image')
                            <p class="text-danger">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Button Link</label>
                        <input type="text" name="btn_link" class="form-control">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Work Submission<span class="text-danger">*</span></label>
                        <select name="work_submit" class="form-select" required>
                            <option value="1">Enabled</option>
                            <option value="0">Disabled</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Commission<span class="text-danger">*</span></label>
                        <input type="number" step="any" min="0" name="commission" class="form-control" value="0" required>
                    </div>
                </div>

            </div>

            <div class="card-footer d-flex justify-content-between">
                <a href="{{ route('admin.courses.index') }}" class="btn btn-dark">Back</a>
                <button type="submit" type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
@endsection
