@extends('layouts.backend.app')

@section('content')
    <h1 class="h3 mb-3">Edit Course</h1>

    <div class="card">
        <form action="{{ route('admin.courses.update', $course->id) }}" method="post" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name<span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" value="{{ $course->name }}" required>
                        @error('name')
                            <p class="text-danger">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Description</label>
                        <textarea name="description" rows="3" class="form-control">{{ $course->description }}</textarea>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Image</label>
                        <input type="file" name="image" class="form-control">
                        @if ($course->image)
                            <small class="d-block mt-1">Current:
                                <img src="{{ asset('storage/' . $course->image) }}" height="80">
                            </small>
                        @endif
                        @error('image')
                            <p class="text-danger">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Button Link</label>
                        <input type="text" name="btn_link" class="form-control" value="{{ $course->btn_link }}">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Work Submission<span class="text-danger">*</span></label>
                        <select name="work_submit" class="form-select" required>
                            <option value="1" {{ $course->work_submit ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ $course->work_submit ? '' : 'selected' }}>Disabled</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Commission<span class="text-danger">*</span></label>
                        <input type="number" step="any" min="0" name="commission" class="form-control"
                            value="{{ $course->commission }}" required>
                    </div>
                </div>

            </div>

            <div class="card-footer d-flex justify-content-between">
                <a href="{{ route('admin.courses.index') }}" class="btn btn-dark">Back</a>
                <button type="submit" type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
@endsection
