@extends('layouts.backend.app')

@section('content')
    <h1 class="h3 mb-3">All Courses</h1>

    <div class="card">
        <div class="card-header">
            <a href="{{ route('admin.courses.create') }}" class="btn btn-primary">Add New</a>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>
                                <i class="align-middle" data-feather="image"></i>
                            </th>
                            <th>Name</th>
                            <th>Commission</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($courses as $i)
                            <tr>
                                <td>
                                    <img src="{{ img($i->image) }}" width="80">
                                </td>
                                <td>
                                    {{ $i->name }}
                                </td>
                                <td>
                                    {{ $i->work_submit ? $i->commission : '-' }}
                                </td>
                                <td>
                                    <a href="{{ route('admin.courses.edit', $i->id) }}" class="btn btn-info">
                                        <i class="align-middle" data-feather="edit"></i>
                                    </a>
                                    <button class="btn btn-danger" onclick="deleteData({{ $i->id }})">
                                        <i class="align-middle" data-feather="trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $courses->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>

    <form action="" method="post" id="delete-form">@csrf @method('DELETE')</form>
@endsection

@push('js')
    <script>
        const deleteForm = document.getElementById('delete-form');

        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored");
            if (ask) {
                deleteForm.action = window.location.origin + window.location.pathname + '/' + id;
                deleteForm.submit();
            }
        }
    </script>
@endpush
