@extends('layouts.backend.app')

@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/css/intlTelInput.css">
    <link rel="stylesheet" href="{{ asset('assets/vendors/select2/select2.min.css') }}">
@endpush

@section('content')
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h1 class="h3 mb-4">Edit User</h1>
        <a href="{{ request('source') ?? url()->previous() }}" class="btn btn-secondary">Back</a>
    </div>


    <div class="card">
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </div>
            @endif
            <form action="{{ route('users.update', $user->id) }}" method="POST">
                @csrf
                @method('PUT')
                <input type="hidden" name="source" value="{{ request('source') }}">
                <input type="hidden" name="phone" value="{{ $user->phone }}">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name*</label>
                        <input type="text" name="name" class="form-control" required value="{{ $user->name }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Phone*</label>
                        <input type="text" id="phone" class="form-control" required value="{{ $user->phone }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control" value="{{ $user->email }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Gender</label>
                        <select name="gender" class="form-select">
                            <option value="">Select</option>
                            <option value="male" {{ $user->gender == 'male' ? 'selected' : '' }}>Male</option>
                            <option value="female" {{ $user->gender == 'female' ? 'selected' : '' }}>Female</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Address</label>
                        <input type="text" name="address" class="form-control" value="{{ $user->address }}">
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" class="form-control">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Payment Status</label>
                        <select name="payment_status" class="form-select">
                            <option value="unpaid" {{ $user->payment_status == 'unpaid' ? 'selected' : '' }}>Unpaid
                            </option>
                            <option value="paid" {{ $user->payment_status == 'paid' ? 'selected' : '' }}>Paid</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="1" {{ $user->status ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ !$user->status ? 'selected' : '' }}>Blocked</option>
                        </select>
                    </div>
                    @if (in_array($role, ['stl', 'tl', 'trainer', 'teacher', 'student']))
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Counselor*</label>
                            <select name="counselor" id="counselor" class="select2 form-control" required>
                                <option value="" selected>Select Option</option>
                                @if ($role == 'stl')
                                    @foreach ($counselors as $cn)
                                        <option value="{{ $cn->id }}"
                                            {{ $user->counselor?->id == $cn->id ? 'selected' : '' }}>{{ $cn->name }}
                                        </option>
                                    @endforeach
                                @elseif ($role == 'tl')
                                    @php
                                        $stl = $user->seniorTeamLeader;
                                        $counselor = $stl?->counselor;
                                    @endphp
                                    @foreach ($counselors as $cn)
                                        <option value="{{ $cn->id }}"
                                            {{ $counselor?->id == $cn->id ? 'selected' : '' }}>{{ $cn->name }}
                                        </option>
                                    @endforeach
                                @else
                                    @php
                                        if($role == 'trainer'){
                                            $tl = $user->teamLeaderOfTrainer;
                                        }
                                        else if($role == 'teacher'){
                                            $tl = $user->teamLeaderOfTeacher;
                                        }else{
                                            $tl = $user->teamLeaderOfStudent;
                                        }
                                        $stl = $tl?->seniorTeamLeader;
                                        $counselor = $stl?->counselor;
                                    @endphp
                                    @foreach ($counselors as $cn)
                                        <option value="{{ $cn->id }}"
                                            {{ $counselor?->id == $cn->id ? 'selected' : '' }}>{{ $cn->name }}
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    @endif
                    @if (in_array($role, ['tl', 'trainer', 'teacher', 'student']))
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Senior Team Leader*</label>
                            <select name="stl" class="select2 form-control" id="stl" required>
                                @if ($stl)
                                    <option value="{{ $stl?->id }}" selected>{{ $stl?->name }}</option>
                                @endif
                            </select>
                        </div>
                    @endif
                    @if (in_array($role, ['trainer', 'teacher', 'student']))
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Team Leader*</label>
                            <select name="tl" class="select2 form-control" id="tl" required>
                                @if ($tl)
                                    <option value="{{ $tl?->id }}" selected>{{ $tl?->name }}</option>
                                @endif
                            </select>
                        </div>
                    @endif
                    @if (in_array($role, ['trainer', 'teacher']))
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Course*</label>
                        <select name="course" class="select2 form-control">
                            <option value="" selected>Select Option</option>
                            @php
                                $teacher = $user->{$user->role};
                            @endphp
                            @foreach ($courses as $c)
                                <option value="{{ $c->id }}" {{ $teacher?->course_id == $c->id ? 'selected' : '' }}>{{ $c->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    @endif
                    <div class="col-12 mt-4">
                        <button class="btn btn-primary">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{ asset('assets/vendors/select2/select2.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/intlTelInput.min.js"></script>
    <script>
        $('.select2').select2()
        intlTelInput(document.getElementById("phone"), {
            loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),
            initialCountry: "bd",
            containerClass: "w-100",
            nationalMode: true,
            hiddenInput: (telInputName) => ({
                phone: "phone",
            }),
        })
        $("#counselor").on("change", function(e) {
            if ($("#stl")[0]) {
                $.ajax({
                    type: "GET",
                    url: `/users/${e.target.value}/stls`,
                    success: function(response) {
                        let html = `<option value="">Select option</option>`
                        $.each(response, function(indexInArray, valueOfElement) {
                            if (valueOfElement.user) {
                                html +=
                                    `<option value="${valueOfElement.user.id}">${valueOfElement.user.name}</option>`
                            }
                        });
                        $("#stl").html(html)
                    }
                });
            }
        });
        $("#stl").on("change", function(e) {
            if ($("#tl")[0]) {
                $.ajax({
                    type: "GET",
                    url: `/users/${e.target.value}/tls`,
                    success: function(response) {
                        let html = `<option value="">Select option</option>`
                        $.each(response, function(indexInArray, valueOfElement) {
                            if (valueOfElement.user) {
                                html +=
                                    `<option value="${valueOfElement.user.id}">${valueOfElement.user.name}</option>`
                            }
                        });
                        $("#tl").html(html)
                    }
                });
            }
        });
    </script>
@endpush
