@extends('layouts.backend.app')

@section('content')
@php
    $url = Request::getRequestUri();
@endphp
    <h1 class="h3 mb-3">All {{ request('role') ?? 'Users' }}</h1>

    <div class="card mb-4">
        <div class="card-header">
            <div class="row">
                <div class="col-md-2 mb-3">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">Add New</button>
                </div>
                <div class="col-md-6 mb-3">
                    <a href="{{ route('users.index') }}"
                        class="btn btn-outline-success btn-sm mr-2 mb-2 {{ !request('role') ? 'btn-success text-light' : '' }}">All</a>
                    @foreach ($roles as $role)
                        <a href="{{ route('users.index', ['role' => $role]) }}"
                            class="btn btn-outline-success btn-sm mr-2 mb-2 {{ request('role') == $role ? 'btn-success text-light' : '' }}">{{ strtoupper($role) }}</a>
                    @endforeach
                </div>
                <div class="col-md-3 mb-3">
                    <form action="" method="get">
                        <input type="text" name="search" class="form-control" placeholder="Type & Enter"
                            value="{{ request('search') }}">
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th>Details</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Balance</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $user)
                        <tr>
                            <td>
                                <img src="{{ img($user->avatar) }}" width="60" class="rounded-circle"></td>
                            <td>
                                ID: {{ $user->id }}<br>
                                Name: {{ $user->name }}<br>
                                Email: {{ $user->email }}<br>
                                Phone: {{ $user->phone }} <br>
                                @if ($user->role == 'student')
                                    Refer By: {{ $user->referer?->name }}({{ $user->referer?->id }}) <br>
                                    <a href="https://wa.me/{{ $user->phone }}?text={{ wp_msg($user) }}" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-primary">{{ $user->role }}</span>
                            </td>
                            <td>
                                @if ($user->verified_at)
                                    @if ($user->status)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Blocked</span>
                                    @endif
                                @else
                                    <span class="badge bg-warning">Pending</span>
                                @endif
                            </td>
                            <td>
                                <span>৳{{ $user->balance }}</span> <br>
                                <button class="btn btn-sm btn-info" onclick="loadModal({{ $user->id }})">Wallet</button>
                            </td>
                            <td>
                                <div class="btn-group">
                                @if ($user->verified_at)
                                    <a href="{{ route('users.edit', ['user' => $user->id, 'source' => $url]) }}" class="btn btn-sm btn-primary">
                                        <i data-feather="edit"></i>
                                    </a>
                                    <a href="{{ route('users.show', ['user' => $user->id, 'source' => $url]) }}" class="btn btn-sm btn-warning">
                                        <i data-feather="eye"></i>
                                    </a>
                                @else
                                    <a href="{{ route('users.edit', ['user' => $user->id, 'source' => $url]) }}" class="btn btn-sm btn-primary">
                                        Approved
                                    </a>
                                @endif
                                <button class="btn btn-sm btn-danger" onclick="deleteData({{ $user->id }})">
                                    <i data-feather="trash-2"></i>
                                </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="p-3">
                {{ $users->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('users.create') }}" method="get">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="addModalLabel">Select Role</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <select name="role" class="form-select" required>
                            <option value="student" selected>Student</option>
                            <option value="counselor">Counselor</option>
                            <option value="manager">Account Manager</option>
                            <option value="teacher">Teacher</option>
                            <option value="trainer">Trainer</option>
                            <option value="tl">Team Leader</option>
                            <option value="stl">Senior Team Lead</option>
                            <option value="admin">Admin</option>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Next</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modal -->
    <div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('updateBalance') }}" method="post">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="walletModalLabel">Update Balance</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="user_id">
                        <input name="amount" type="number" step="any" min="1" class="mb-3 form-control" required placeholder="amount">
                        <select name="type" class="mb-3 form-select" required>
                            <option value="credit">Cash in</option>
                            <option value="debit">Cash out</option>
                        </select>
                        <input name="details" type="text" class="mb-3 form-control" placeholder="details" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    {{-- individual delete --}}
    <form action="#" method="post" id="delete-form">
        @csrf
        @method('DELETE')
    </form>
@endsection

@push('js')
    <script>
        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored!")
            if (ask) {
                $("#delete-form").attr('action', `{{ route('users.index') }}/${id}`);
                $("#delete-form").submit();
            }
        }
        const myModal = new bootstrap.Modal("#walletModal")
        function loadModal(id){
            $("#user_id").val(id)
            myModal.show()
        }

    </script>
@endpush
