@extends('layouts.app')

@section('content')
<h3 class="mb-4">All Senior Team Leaders</h3>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Name</th>
                            {{-- @if ($user->role != 'tl')
                                <th>Team Leader</th>
                            @endif --}}
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($leaders as $leader)
                            <tr>
                                <td>{{ $leader->user?->id }}</td>
                                <td><img src="{{ img($leader->user?->avatar) }}" width="60" class="rounded-circle"></td>
                                <td>{{ $leader->user?->name }}</td>
                                {{-- @if ($user->role != 'tl')
                                    <td>{{ $leader->team_leader?->name }}</td>
                                @endif --}}
                                <td>
                                    <a href="https://wa.me/{{ $leader->user?->phone }}?text={{ wp_msg($leader->user) }}" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $leaders->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection