@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-md-12 grid-margin">
            <div class="row">
                <div class="col-12 col-xl-8 mb-4 mb-xl-0">
                    <h3 class="fw-bold">Welcome {{ $user->name }} ,{{ $user->id }} </h3>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 grid-margin transparent">
            <div class="row">
                <div class="col-md-6 mb-4 stretch-card transparent">
                    <div class="card card-tale">
                        <div class="card-body">
                            <p class="mb-4">Notes Board</p>
                            <p class="fs-10 mb-2">আসসালামু আলাইকুম  ,{{ $user->name }} {{ $settings['notes_board'] }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4 stretch-card transparent">
                    <div class="card card-dark-blue">
                        <div class="card-body">
                            <p class="mb-4">Current Balance</p>
                            <p class="fs-30 mb-2">৳{{$user->balance}}</p>
                        </div>
                    </div>
                </div>
            </div>
            
             <div class="row">
        <div class="col-12 grid-margin transparent">
            <div class="row">
                <div class="col-md-6 mb-4 stretch-card transparent">
                    <div class="card card-tale">
                        <div class="card-body">
                            <p class="mb-4">Total Withdraws</p>
                            <p class="fs-30 mb-2">৳{{ $totalWithdraws }}</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                <div class="col-md-6 mb-4 stretch-card transparent">
                    <div class="card card-light-blue">
                        <div class="card-body">
                            <p class="mb-4">Total Leads from Referral</p>
                            <p class="fs-30 mb-2">{{ $totalLeads }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4 stretch-card transparent">
                    <div class="card card-light-danger">
                        <div class="card-body">
                            <p class="mb-4">Student ID</p>
                            <p class="fs-30 mb-2">{{ $user->id }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-4 stretch-card transparent">
                    <div class="card card-tale">
                        <div class="card-body">
                            <p class="mb-4">Joining Date</p>
                            <p class="fs-30 mb-2">
                                {{ $user->created_at->format('d M Y') }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4 stretch-card transparent">
                    <div class="card card-dark-blue">
                        <div class="card-body">
                            <p class="mb-4">Activation Date</p>
                            <p class="fs-30 mb-2">
                                {{ \Carbon\Carbon::parse($user->verified_at)->format('d M Y') }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- <div class="container mt-4">
    <h3 class="mb-4">Dashboard ({{ $user->role }})</h3>

    <div class="card shadow-sm border-0">
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-4 mb-3">
                    <div class="p-3 border rounded bg-light">
                        <h6 class="text-muted">ID</h6>
                        <h5 class="mb-0">{{ $user->id }}</h5>
                    </div>
                </div>

                <div class="col-md-4 mb-3">
                    <div class="p-3 border rounded bg-light">
                        <h6 class="text-muted">Name</h6>
                        <h5 class="mb-0">{{ $user->name }}</h5>
                    </div>
                </div>

                <div class="col-md-4 mb-3">
                    <div class="p-3 border rounded bg-light">
                        <h6 class="text-muted">Balance</h6>
                        <h5 class="mb-0 text-success">৳{{ number_format($user->balance, 2) }}</h5>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="p-3 border rounded bg-light">
                        <h6 class="text-muted">Joining Date</h6>
                        <h5 class="mb-0">{{ $user->created_at->format('d M Y') }}</h5>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="p-3 border rounded bg-light">
                        <h6 class="text-muted">Activation Date</h6>
                        <h5 class="mb-0">
                            {{ \Carbon\Carbon::parse($user->verified_at)->format('d M Y') }}
                        </h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> --}}
@endsection
