@extends('layouts.app')

@section('content')
<h3 class="mb-4">My Passbook</h3>

    <div class="card">
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Amount</th>
                            <th>Details</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($transactions as $key => $transaction)
                            <tr class="{{ $transaction->type == 'credit' ? 'table-success' : 'table-danger' }}">
                                <td>{{ $transactions->firstItem() + $key }}</td>
                                <td>{{ $transaction->created_at->format('d M Y, h:i A') }}</td>
                                <td>{{ $transaction->type == 'credit' ? '+' : '-' }}{{ $transaction->amount }}</td>
                                <td>
                                    {{ $transaction->details }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $transactions->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection
