@extends('layouts.app')

@section('content')
<h3 class="mb-4">My Referral Code</h3>
    <div class="card">
        <div class="card-body">
            <h5 class="text-muted mb-3">Student ID: <strong>{{ $user->id }}</strong></h5>

            <div class="mb-4">
                <label class="form-label" for="referralURL">Referral Link</label>
                <div class="input-group">
                    <input type="text" value="{{ route('register', ['reference' => $user->id]) }}" class="form-control"
                        id="referralURL" readonly>
                    <button class="btn btn-outline-primary" id="copyBoard"><i class="ti-clipboard"></i></button>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-light text-danger">
                        <strong>Total Leads:</strong> {{ $totalLeads }}
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-light text-danger">
                        <strong>Today's Leads:</strong> {{ $todayLeads }}
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-success text-white">
                        <strong>Total Converted:</strong> {{ $totalConverted }}
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-success text-white">
                        <strong>Today's Converted:</strong> {{ $todayConverted }}
                    </div>
                </div>
            </div>            

            <h5 class="mb-3">All Leads</h5>

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Student ID</th>
                            <th>Name</th>
                            <th>Joining Date</th>
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($leads as $lead)
                            <tr>
                                <td><strong>{{ $lead->id }}</strong></td>
                                <td>{{ $lead->name }}</td>
                                <td>{{ $lead->created_at->format('d M Y') }}</td>
                                <td>
                                    <a href="https://wa.me/{{ $lead->phone }}?text={{ wp_msg($lead) }}" target="_blank" class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $leads->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
<script>
    document.getElementById('copyBoard').addEventListener('click', function () {
        const input = document.getElementById('referralURL');
        input.select();
        input.setSelectionRange(0, 99999);

        try {
            const success = document.execCommand('copy');
            if (success) {
                toastMagic.success('Referral link copied to clipboard!');
            } else {
                toastMagic.error('Failed to copy referral link.');
            }
        } catch (err) {
            toastMagic.error('Oops! Unable to copy.');
        }
    });
</script>
@endpush
