@extends('layouts.app')

@section('content')
<h3 class="mb-4">Join Class</h3>

    <div class="card">
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Added By</th>
                            <th>Course</th>
                            <th>Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($links as $i)
                            <tr>
                                <td>
                                    ID: {{ $i->user?->id }} <br>
                                    Name: {{ $i->user?->name }} <br>
                                    Role: {{ $i->user?->role }}
                                </td>
                                <td>
                                    {{ $i->course?->name }}
                                </td>
                                <td>
                                    {{ $i->time->format('d M Y, h:i a') }}
                                </td>
                                <td>
                                    <a target="_blank" href="{{ $i->link }}" class="btn btn-sm btn-primary">Join</a>
                                    <a href="{{ route('studentWorks') }}" class="btn btn-sm btn-dark">Work Submit</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $links->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
@endsection