@extends('layouts.app')

@section('content')
<h3 class="mb-4">Work Submit</h3>

    <div class="card">
        <div class="card-body">
            <h5 class="text-info mb-3">Total Limit: {{ $settings['total_work_limit'] }}</h5>
            <h5 class="text-info mb-3">Per Day Per Course Limit: {{ $settings['per_day_per_course_work_limit'] }}</h5>

            <div class="mb-4">
                <form action="{{ route('studentWorks') }}" method="POST">
                    @csrf
                    {{-- @if (!$user->pending_fee)
                        <label class="form-label mb-3 d-block text-warning" for="referralURL">Note: Your pending fee is
                            ৳{{ $settings['pending_fee'] }}</label>
                        <button type="submit" class="btn btn-primary">Pay Pending Fee</button>
                    @else
                        @if (!$user->last_withdraw || \Carbon\Carbon::parse($user->last_withdraw)->diffInDays(now()) >= 7) --}}
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Course</label>
                                    <select name="course" class="form-select" required>
                                        <option value="">Select</option>
                                        @foreach ($courses as $c)
                                            <option value="{{ $c->id }}">{{ $c->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Link</label>
                                    <input type="text" name="link" class="form-control form-control-sm" required>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">Note</label>
                                    <textarea name="note" rows="2" class="form-control"></textarea>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        {{-- @endif
                    @endif --}}
                </form>
            </div>

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Date</th>
                            <th>Course</th>
                            <th>Link</th>
                            <th>Note</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($works as $i)
                            <tr>
                                <td>{{ $i->created_at->format('d M Y') }}</td>
                                <td>{{ $i->course?->name }}</td>
                                <td>
                                    <a target="_blank" href="{{ $i->link }}" class="btn btn-sm btn-primary">Click</a>
                                </td>
                                <td>{{ $i->note }}</td>
                                <td>
                                    @if ($i->status == 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($i->status == 'approved')
                                        <span class="badge bg-success">Approved</span>
                                    @else
                                        <span class="badge bg-danger">Declined</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $works->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection