@extends('layouts.app')

@section('content')
    <h3 class="mb-4">Active Students</h3>
    <div class="card">
        <div class="card-body">
            <form action="" method="get">
            <div class="row mb-3">
                    <div class="col-8">
                        <input type="text" name="query" class="form-control form-control-sm" placeholder="student id or phone number"
                        value="{{ request('query') }}">
                    </div>
                    <div class="col-4">
                        <button class="btn btn-dark">Search</button>
                    </div>
                </div>
            </form>
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Trainer</th>
                            <th>Teacher</th>
                            <th>Status</th>
                            <th>WhatsApp</th>
                            @if ($user->role == 'tl')
                            <th>Action</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($students as $student)
                            <tr>
                                <td>{{ $student->user?->id }}</td>
                                <td><img src="{{ img($student->user?->avatar) }}" width="60" class="rounded-circle"></td>
                                <td>{{ $student->user?->name }}</td>
                                <td>{{ $student->trainer?->name }}</td>
                                <td>{{ $student->teacher?->name }}</td>
                                <td>
                                    @if ($student->user?->status)
                                        <span class="badge bg-primary">Active</span>
                                    @else
                                        <span class="badge bg-danger">Blocked</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="https://wa.me/{{ $student->user?->phone }}?text={{ wp_msg($student->user) }}" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                                @if ($user->role == 'tl')
                                <td>
                                    <a href="{{ route('students.edit', $student->user?->id) }}" class="btn btn-primary btn-sm">
                                        <i class="ti-pencil"></i>
                                    </a>
                                </td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $students->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection