@extends('layouts.app')

@push('css')
    <link rel="stylesheet" href="{{ asset('assets/vendors/select2/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendors/select2-bootstrap-theme/select2-bootstrap.min.css') }}">
@endpush

@section('content')
    <h3 class="mb-4">Edit Student [{{ $student->name }} #{{ $student->id }}]</h3>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('students.update', $student->id) }}" method="post">
                @csrf
                @method('put')
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Trainer</label>
                        <select name="trainer" class="select2 w-100">
                            <option value="">Select Option</option>
                            @foreach ($trainers as $tr)
                                <option value="{{ $tr->user_id }}"
                                    {{ $student->student?->trainer_id == $tr->user_id ? 'selected' : '' }}>{{ $tr->user?->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Teacher</label>
                        <select name="teacher" class="select2 w-100">
                            <option value="">Select Option</option>
                            @foreach ($teachers as $tc)
                                <option value="{{ $tc->user_id }}"
                                    {{ $student->student?->teacher_id == $tc->user_id ? 'selected' : '' }}>{{ $tc->user?->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">Save</button>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{ asset('assets/vendors/select2/select2.min.js') }}"></script>
    <script>
        $(".select2").select2();
    </script>
@endpush