@extends('layouts.app')

@section('content')
<h3 class="mb-4">All Teachers</h3>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Name</th>
                            @if ($user->role != 'tl')
                                <th>Team Leader</th>
                            @endif
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($teachers as $teacher)
                            <tr>
                                <td>{{ $teacher->user?->id }}</td>
                                <td><img src="{{ img($teacher->user?->avatar) }}" width="60" class="rounded-circle"></td>
                                <td>{{ $teacher->user?->name }}</td>
                                @if ($user->role != 'tl')
                                    <td>{{ $teacher->team_leader?->name }}</td>
                                @endif
                                <td>
                                    <a href="https://wa.me/{{ $teacher->user?->phone }}?text={{ wp_msg($teacher->user) }}" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $teachers->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection