@extends('layouts.app')

@section('content')
    <h3 class="mb-4">Work Submissions</h3>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Date</th>
                            <th>Student</th>
                            <th>Course</th>
                            <th>Link</th>
                            <th>Note</th>
                            <th>Status</th>
                            <th>Trainer/Teacher</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($works as $i)
                            <tr>
                                <td>{{ $i->created_at->format('d M Y') }}</td>
                                <td>
                                    ID: {{ $i->user?->id }} <br>
                                    Name: {{ $i->user?->name }}
                                </td>
                                <td>{{ $i->course?->name }}</td>
                                <td>
                                    <a target="_blank" href="{{ $i->link }}" class="btn btn-sm btn-primary">Click</a>
                                </td>
                                <td>{{ $i->note }}</td>
                                <td>
                                    @if ($i->status == 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($i->status == 'approved')
                                        <span class="badge bg-success">Approved</span>
                                    @else
                                        <span class="badge bg-danger">Declined</span>
                                    @endif
                                </td>
                                <td>
                                    @if (!$i->trainer_status)
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-success"
                                                onclick="changeStatus({{ $i->id }}, 'approved')">
                                                <i class="ti-check"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger"
                                                onclick="changeStatus({{ $i->id }}, 'declined')">
                                                <i class="ti-close"></i>
                                            </button>
                                        </div>
                                    @elseif($i->trainer_status == 'approved')
                                        <span class="badge bg-success">Approved</span>
                                    @else
                                        <span class="badge bg-danger">Declined</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $works->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>

    <form action="{{ route('works') }}" method="post" id="status-form">
        <input type="hidden" name="id" id="user_id">
        <input type="hidden" name="status" id="status">
        @csrf
    </form>
@endsection

@push('js')
    <script>
        function changeStatus(id, status) {
            let ask = confirm("Status can't be restored!")
            if (ask) {
                $("#user_id").val(id)
                $("#status").val(status)
                $("#status-form").submit();
            }
        }
    </script>
@endpush