

<?php $__env->startSection('content'); ?>
<h3 class="mb-4">All Teachers</h3>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Name</th>
                            <?php if($user->role != 'tl'): ?>
                                <th>Team Leader</th>
                            <?php endif; ?>
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($teacher->user?->id); ?></td>
                                <td><img src="<?php echo e(img($teacher->user?->avatar)); ?>" width="60" class="rounded-circle"></td>
                                <td><?php echo e($teacher->user?->name); ?></td>
                                <?php if($user->role != 'tl'): ?>
                                    <td><?php echo e($teacher->team_leader?->name); ?></td>
                                <?php endif; ?>
                                <td>
                                    <a href="https://wa.me/<?php echo e($teacher->user?->phone); ?>?text=<?php echo e(wp_msg($teacher->user)); ?>" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($teachers->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/tl/teachers.blade.php ENDPATH**/ ?>