

<?php $__env->startSection('content'); ?>
    <h3 class="mb-4">Work Submissions</h3>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Date</th>
                            <th>Student</th>
                            <th>Course</th>
                            <th>Link</th>
                            <th>Note</th>
                            <th>Status</th>
                            <th>Trainer/Teacher</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i->created_at->format('d M Y')); ?></td>
                                <td>
                                    ID: <?php echo e($i->user?->id); ?> <br>
                                    Name: <?php echo e($i->user?->name); ?>

                                </td>
                                <td><?php echo e($i->course?->name); ?></td>
                                <td>
                                    <a target="_blank" href="<?php echo e($i->link); ?>" class="btn btn-sm btn-primary">Click</a>
                                </td>
                                <td><?php echo e($i->note); ?></td>
                                <td>
                                    <?php if($i->status == 'pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php elseif($i->status == 'approved'): ?>
                                        <span class="badge bg-success">Approved</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Declined</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(!$i->trainer_status): ?>
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-success"
                                                onclick="changeStatus(<?php echo e($i->id); ?>, 'approved')">
                                                <i class="ti-check"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger"
                                                onclick="changeStatus(<?php echo e($i->id); ?>, 'declined')">
                                                <i class="ti-close"></i>
                                            </button>
                                        </div>
                                    <?php elseif($i->trainer_status == 'approved'): ?>
                                        <span class="badge bg-success">Approved</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Declined</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($works->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>

    <form action="<?php echo e(route('works')); ?>" method="post" id="status-form">
        <input type="hidden" name="id" id="user_id">
        <input type="hidden" name="status" id="status">
        <?php echo csrf_field(); ?>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function changeStatus(id, status) {
            let ask = confirm("Status can't be restored!")
            if (ask) {
                $("#user_id").val(id)
                $("#status").val(status)
                $("#status-form").submit();
            }
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/oursopno/smm.oursopnozonebd.top/resources/views/trainer_teacher/works.blade.php ENDPATH**/ ?>