

<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3">Settings</h1>

    <div class="card card-primary card-outline mb-4">

        <form action="<?php echo e(route('admin.settings')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="row">
                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4 mb-3">
                            <label class="form-label"><?php echo e(ucwords(str_replace('_', ' ', $key))); ?></label>

                            <?php if(in_array($key, ['site_logo', 'mobile_logo'])): ?>
                                
                                <input type="file" name="<?php echo e($key); ?>" class="form-control" />
                                <?php if($value): ?>
                                    <small class="d-block mt-1">Current:
                                        <img src="<?php echo e(asset('storage/' . $value)); ?>" alt="<?php echo e($key); ?>"
                                            height="40">
                                    </small>
                                <?php endif; ?>
                            <?php elseif($key == 'payment_gateway'): ?>
                                
                                <select name="<?php echo e($key); ?>" class="form-select">
                                    <option value="1" <?php echo e($value ? 'selected' : ''); ?>>Enabled</option>
                                    <option value="0" <?php echo e(!$value ? 'selected' : ''); ?>>Disabled</option>
                                </select>
                            <?php else: ?>
                                
                                <input name="<?php echo e($key); ?>" type="text" class="form-control"
                                    value="<?php echo e($value); ?>" />
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/easyecommeplatm/public_html/resources/views/backend/settings.blade.php ENDPATH**/ ?>