

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/css/intlTelInput.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger mb-3">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <!-- Left Column: Avatar + Info -->
                
                  <a href="<?php echo e(route('profile')); ?>">
                            <span class="fs-30 mb-4 btn-sm mb-2">Profile</span>
                        </a>
                        
                        
                       <a href="<?php echo e(route('referral')); ?>">
                            <span class="fs-30 mb-2 btn-sm mb-2">Referral</span>
                        </a>
                        
                        
                          <a href="<?php echo e(route('passbook')); ?>">
                            <span class="fs-30 mb-2 btn-sm mb-2">My Passbook</span>
                        </a>
                        
                        
                          <a href="<?php echo e(route('withdrawal')); ?>">
                            <span class="fs-30 mb-2 btn-sm mb-2">Withdrawal</span>
                        </a>
                        
                         <?php if($user->role == 'student'): ?>
                        
                          <a href="<?php echo e(route('joinClass')); ?>">
                            <span class="fs-30 mb-2 btn-sm mb-2">Join Class</span>
                        </a>
                        
                        
                        
                          <a href="<?php echo e(route('studentWorks')); ?>">
                            <span class="fs-30 mb-2 btn-sm mb-2">Work Submit</span>
                        </a>
                
                <?php endif; ?>
                
                
                
                
                
                <div class="col-lg-4 text-center border-end">
                    <div class="position-relative d-inline-block">
                        <img src="<?php echo e(img($user->avatar)); ?>" alt="profile" class="img-lg rounded-circle mb-3"
                            id="avatarPreview" />

                        <!-- Edit icon -->
                        <label for="avatarUpload"
                            class="position-absolute bottom-0 end-0 bg-white rounded-circle p-1 shadow"
                            style="cursor:pointer;">
                            <i class="ti-pencil text-primary"></i>
                        </label>

                    </div>
                    <h4><?php echo e($user->name); ?></h4>
                    <h5 class="text-muted mb-2">Student ID: <strong><?php echo e($user->id); ?></strong></h5>
                    <h5 class="text-muted mb-4">Balance: <strong>৳<?php echo e($user->balance); ?></strong></h5>
                </div>

                <!-- Right Column: Editable Form -->
                <div class="col-lg-8">
                    <h5 class="mb-4">Edit Profile Information</h5>
                    <form action="<?php echo e(route('profile')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="file" name="avatar" id="avatarUpload" accept="image/*" class="d-none"
                            onchange="previewAvatar(event)">

                        <div class="row mb-3">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>"
                                    required />
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Phone</label>
                                <input type="hidden" name="phone">
                                <input type="tel" id="phone" class="form-control" value="<?php echo e($user->phone); ?>"
                                    required />
                            </div>

                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" value="<?php echo e($user->email); ?>" />
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Gender</label>
                                <select class="form-select" name="gender" required>
                                    <option value="">Select Option</option>
                                    <option value="male" <?php echo e($user->gender == 'male' ? 'selected' : ''); ?>>Male</option>
                                    <option value="female" <?php echo e($user->gender == 'female' ? 'selected' : ''); ?>>Female
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Address</label>
                                <textarea name="address" class="form-control" rows="2" required><?php echo e($user->address); ?></textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Change Password</label>
                                <input type="password" name="password" class="form-control" autocomplete="off" />
                            </div>
                        </div>
                        <button type="submit" class="btn btn-success">Update Profile</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/intlTelInput.min.js"></script>

    <script>
        function previewAvatar(event) {
            const input = event.target;
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('avatarPreview').src = e.target.result;
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
        const input = document.getElementById("phone");
        intlTelInput(input, {
            loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),
            initialCountry: "bd",
            containerClass: "w-100",
            nationalMode: true,
            hiddenInput: (telInputName) => ({
                phone: "phone",
            }),
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/munfashion/public_html/resources/views/profile.blade.php ENDPATH**/ ?>