

<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3">Work Submissions</h1>

    <div class="card mb-4">
        <div class="card-body table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Student</th>
                        <th>Course</th>
                        <th>Link</th>
                        <th>Note</th>
                        <th>Trainer/Teacher</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($i->created_at->format('d M Y')); ?></td>
                            <td>
                                ID: <?php echo e($i->user?->id); ?> <br>
                                Name: <?php echo e($i->user?->name); ?>

                            </td>
                            <td><?php echo e($i->course?->name); ?></td>
                            <td>
                                <a target="_blank" href="<?php echo e($i->link); ?>" class="btn btn-sm btn-primary">Click</a>
                            </td>
                            <td><?php echo e($i->note); ?></td>
                            <td>
                                <?php if(!$i->trainer_status): ?>
                                <?php elseif($i->trainer_status == 'approved'): ?>
                                    <span class="badge bg-success">Approved</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Declined</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($i->status == 'pending'): ?>
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-success"
                                        onclick="changeStatus(<?php echo e($i->id); ?>, 'approved')">
                                        <i data-feather="check"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger"
                                        onclick="changeStatus(<?php echo e($i->id); ?>, 'declined')">
                                        <i data-feather="x"></i>
                                    </button>
                                </div>
                                <?php elseif($i->status == 'approved'): ?>
                                    <span class="badge bg-success">Approved</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Declined</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-danger" onclick="deleteData(<?php echo e($user->id); ?>)">
                                    <i data-feather="trash-2"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="p-3">
                <?php echo e($works->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>

    
    <form action="<?php echo e(route('works')); ?>" method="post" id="status-form">
        <input type="hidden" name="id" id="user_id">
        <input type="hidden" name="status" id="status">
        <?php echo csrf_field(); ?>
    </form>
    <form action="#" method="post" id="delete-form">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function changeStatus(id, status) {
            let ask = confirm("Status can't be restored!")
            if (ask) {
                $("#user_id").val(id)
                $("#status").val(status)
                $("#status-form").submit();
            }
        }
        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored!")
            if (ask) {
                $("#delete-form").attr('action', `<?php echo e(route('users.index')); ?>/${id}`);
                $("#delete-form").submit();
            }
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.backend.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/backend/works/index.blade.php ENDPATH**/ ?>