

<?php $__env->startSection('content'); ?>
<h3 class="mb-4">Withdrawals</h3>

    <div class="card">
        <div class="card-body">
            <h5 class="mb-3">Current Balance: <strong>৳<?php echo e($user->balance); ?></strong></h5>
            <h5 class="text-info mb-3">Withdraw Time: 1 time in a week</h5>

            <div class="mb-4">
                <form action="<?php echo e(route('withdrawal')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php if(!$user->pending_fee): ?>
                        <label class="form-label mb-3 d-block text-warning" for="referralURL">Note: Your pending fee is
                            ৳<?php echo e($settings['pending_fee']); ?></label>
                        <button type="submit" class="btn btn-primary">Pay Pending Fee</button>
                    <?php else: ?>
                        <?php if(!$user->last_withdraw || \Carbon\Carbon::parse($user->last_withdraw)->diffInDays(now()) >= 7): ?>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Account Number</label>
                                    <input type="text" name="account_number" class="form-control form-control-sm"
                                        placeholder="018********" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Payment Method</label>
                                    <select name="method" class="form-select" required>
                                        <option value="">Select Method</option>
                                        <option value="Bkash">Bkash</option>
                                        <option value="Nagad">Nagad</option>
                                        <option value="Rocket">Rocket</option>
                                        <option value="Upay">Upay</option>
                                        <option value="Google Pay">Google Pay</option>
                                        <option value="Paytm">Paytm</option>
                                        <option value="PhonePe">PhonePe</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Account Type</label>
                                    <select name="type" class="form-select" required>
                                        <option value="personal">Personal</option>
                                        <option value="agent">Agent</option>
                                        <option value="merchant">Merchant</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Amount</label>
                                    <input type="number" name="amount" min="1" max="<?php echo e($user->balance); ?>"
                                        class="form-control form-control-sm" placeholder="Type amount" required>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">Make Withdraw</button>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </form>
            </div>

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Request Date</th>
                            <th>Amount</th>
                            <th>Details</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $details = json_decode($i->details, true);
                        ?>

                            <tr>
                                <td><?php echo e($withdrawals->firstItem() + $key); ?></td>
                                <td><?php echo e($i->created_at->format('d M Y')); ?></td>
                                <td><?php echo e($i->amount); ?></td>
                                <td>
                                    <ul class="mb-0 list-style-none">
                                        <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><strong><?php echo e(ucwords(str_replace('_', ' ', $key))); ?>:</strong> <?php echo e($value); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>                                    
                                </td>
                                <td>
                                    <?php if($i->status == 'pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php elseif($i->status == 'approved'): ?>
                                        <span class="badge bg-success">Approved</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Declined</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($withdrawals->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/munfashion/public_html/resources/views/withdrawal.blade.php ENDPATH**/ ?>