<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Admin Panel - <?php echo e(config('app.name')); ?></title>

    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/app.css')); ?>" rel="stylesheet">
    <?php echo ToastMagic::styles(); ?>

    <?php echo $__env->yieldPushContent('css'); ?>
</head>

<body>
    <?php
        $user = Auth::user();
    ?>

    <div class="wrapper">
        <?php echo $__env->make('layouts.backend.sidebar', ['user' => $user], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <div class="main">
            <nav class="navbar navbar-expand navbar-light navbar-bg">
                <a class="sidebar-toggle js-sidebar-toggle">
                    <i class="hamburger align-self-center"></i>
                </a>

                <div class="navbar-collapse collapse">
                    <ul class="navbar-nav navbar-align">
                        <li class="nav-item dropdown">
                            <a class="nav-icon dropdown-toggle d-inline-block d-sm-none" href="#"
                                data-bs-toggle="dropdown">
                                <i class="align-middle" data-feather="settings"></i>
                            </a>

                            <a class="nav-link dropdown-toggle d-none d-sm-inline-block" href="#"
                                data-bs-toggle="dropdown">
                                <img src="<?php echo e(img($user->avatar)); ?>"
                                    class="avatar img-fluid rounded me-1" alt="<?php echo e($user->name); ?>" /> <span
                                    class="text-dark"><?php echo e($user->name); ?></span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <a class="dropdown-item" href="<?php echo e(route('profile')); ?>">Profile</a>
                                <a class="dropdown-item" href="javascript:void(0)" onclick="logout()">Log out</a>
                                <form action="<?php echo e(route('logout')); ?>" method="post" id="logout-form"><?php echo csrf_field(); ?></form>
                            </div>
                        </li>
                    </ul>
                </div>
            </nav>

            <main class="content">
                <div class="container-fluid p-0">

                    <?php echo $__env->yieldContent('content'); ?>

                </div>
            </main>

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row text-muted">
                        <div class="col-6 text-start">
                            <p class="mb-0">
                                &copy; 2025 All Rights Reserved
                            </p>
                        </div>
                        <div class="col-6 text-end">
                            <a target="_blank" href="https://wa.me/+8801300374181">Developed by BDHOST24H</a>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <script src="<?php echo e(asset('backend/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/app.js')); ?>"></script>
    <script>
        function logout() {
            document.getElementById("logout-form").submit()
        }
    </script>
    <?php echo ToastMagic::scripts(); ?>   
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html><?php /**PATH /home/theearn1/public_html/resources/views/layouts/backend/app.blade.php ENDPATH**/ ?>