

<?php $__env->startSection('content'); ?>
<?php
    $url = Request::getRequestUri();
?>
    <h1 class="h3 mb-3">All <?php echo e(request('role') ?? 'Users'); ?></h1>

    <div class="card mb-4">
        <div class="card-header">
            <div class="row">
                <div class="col-md-2 mb-3">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">Add New</button>
                </div>
                <div class="col-md-6 mb-3">
                    <a href="<?php echo e(route('users.index')); ?>"
                        class="btn btn-outline-success btn-sm mr-2 mb-2 <?php echo e(!request('role') ? 'btn-success text-light' : ''); ?>">All</a>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('users.index', ['role' => $role])); ?>"
                            class="btn btn-outline-success btn-sm mr-2 mb-2 <?php echo e(request('role') == $role ? 'btn-success text-light' : ''); ?>"><?php echo e(strtoupper($role)); ?></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="col-md-3 mb-3">
                    <form action="" method="get">
                        <input type="text" name="search" class="form-control" placeholder="Type & Enter"
                            value="<?php echo e(request('search')); ?>">
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th>Details</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Balance</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <img src="<?php echo e(img($user->avatar)); ?>" width="60" class="rounded-circle"></td>
                            <td>
                                ID: <?php echo e($user->id); ?><br>
                                Name: <?php echo e($user->name); ?><br>
                                Email: <?php echo e($user->email); ?><br>
                                Phone: <?php echo e($user->phone); ?> <br>
                                <?php if($user->role == 'student'): ?>
                                    Refer By: <?php echo e($user->referer?->name); ?>(<?php echo e($user->referer?->id); ?>) <br>
                                    <a href="https://wa.me/<?php echo e($user->phone); ?>?text=<?php echo e(wp_msg($user)); ?>" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge bg-primary"><?php echo e($user->role); ?></span>
                            </td>
                            <td>
                                <?php if($user->verified_at): ?>
                                    <?php if($user->status): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Blocked</span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="badge bg-warning">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span>৳<?php echo e($user->balance); ?></span> <br>
                                <button class="btn btn-sm btn-info" onclick="loadModal(<?php echo e($user->id); ?>)">Wallet</button>
                            </td>
                            <td>
                                <div class="btn-group">
                                <?php if($user->verified_at): ?>
                                    <a href="<?php echo e(route('users.edit', ['user' => $user->id, 'source' => $url])); ?>" class="btn btn-sm btn-primary">
                                        <i data-feather="edit"></i>
                                    </a>
                                    <a href="<?php echo e(route('users.show', ['user' => $user->id, 'source' => $url])); ?>" class="btn btn-sm btn-warning">
                                        <i data-feather="eye"></i>
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('users.edit', ['user' => $user->id, 'source' => $url])); ?>" class="btn btn-sm btn-primary">
                                        Approved
                                    </a>
                                <?php endif; ?>
                                <button class="btn btn-sm btn-danger" onclick="deleteData(<?php echo e($user->id); ?>)">
                                    <i data-feather="trash-2"></i>
                                </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="p-3">
                <?php echo e($users->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="<?php echo e(route('users.create')); ?>" method="get">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="addModalLabel">Select Role</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <select name="role" class="form-select" required>
                            <option value="student" selected>Student</option>
                            <option value="counselor">Counselor</option>
                            <option value="manager">Account Manager</option>
                            <option value="teacher">Teacher</option>
                            <option value="trainer">Trainer</option>
                            <option value="tl">Team Leader</option>
                            <option value="stl">Senior Team Lead</option>
                            <option value="admin">Admin</option>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Next</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Modal -->
    <div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="<?php echo e(route('updateBalance')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="walletModalLabel">Update Balance</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="user_id">
                        <input name="amount" type="number" step="any" min="1" class="mb-3 form-control" required placeholder="amount">
                        <select name="type" class="mb-3 form-select" required>
                            <option value="credit">Cash in</option>
                            <option value="debit">Cash out</option>
                        </select>
                        <input name="details" type="text" class="mb-3 form-control" placeholder="details" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <form action="#" method="post" id="delete-form">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored!")
            if (ask) {
                $("#delete-form").attr('action', `<?php echo e(route('users.index')); ?>/${id}`);
                $("#delete-form").submit();
            }
        }
        const myModal = new bootstrap.Modal("#walletModal")
        function loadModal(id){
            $("#user_id").val(id)
            myModal.show()
        }

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/oursopno/smm.oursopnozonebd.top/resources/views/backend/users/index.blade.php ENDPATH**/ ?>