# Security Policy

## Supported Versions
We actively maintain the latest major version of Laravel Toaster Magic. Security updates will only be provided for the latest release.

| Version | Supported          |
|---------|------------------|
| Latest  | ✅ Active Support |
| Older   | ❌ No Support    |

## Reporting a Vulnerability
If you discover a security vulnerability in Laravel Toaster Magic, please **DO NOT** disclose it publicly. Instead, report it confidentially by following these steps:

1. **Email the Maintainer**: Send a detailed report to [devrabiul@gmail.com] with the subject **[Security Issue] Laravel Toaster Magic**.
2. **Include Details**:
   - Affected version(s)
   - Steps to reproduce the issue
   - Potential impact
   - Suggested fix (if any)
3. **Await Response**: We will investigate the issue and respond as soon as possible, typically within 72 hours.
4. **Patch and Disclosure**: Once a fix is developed and tested, we will release a security update and acknowledge your responsible disclosure.

## Best Practices for Users
To keep your application secure:
- Always update to the latest version.
- Use Composer to manage dependencies securely.
- Follow Laravel's security best practices.

We appreciate your help in making Laravel Toaster Magic more secure! 🔒
